define([
    'underscore',
    'backbone',
    'marionette',
    'Layout',
    'modules/appointments/list-section/appointments-section-view',
], function(_, Backbone, Marionette, Layout, AppointmentsSectionView) {
    'use strict';

    describe('Appointments Section View', function() {
        var TestView = AppointmentsSectionView.extend({
            template: _.template('<div class="appointments-contain"></div>'),
            regions: {appointmentsListRegion: '.appointments-contain'},
            initialize: function() {
                if (_.isUndefined(this.collection)) {
                    this.collection = new Backbone.Collection();
                }
            },
            render: function() {
                this._initializeSectionView({
                    noAppointmentsTemplate: _.template('<p class="no-appointments">No Appointments</p>'),
                    AppointmentsListView: Backbone.Marionette.View,
                });
            },
        });
        var view;
        var layout = new Layout();

        layout.render();

        // TODO: upgrade Jasmine, change to beforeAll
        beforeEach(function() {
            spyOn(TestView.prototype, '_initializeSectionView').and.callThrough();
            spyOn(TestView.prototype, 'showAppointmentsView');

            view = new TestView();

            layout.showChildView('content', view);
        });

        it('has a helper to _initializeSectionView()', function() {
            expect(view._initializeSectionView).toHaveBeenCalled();
        });

        it("reloads and shows filtered appointments on 'sync' event", function() {
            view.trigger('sync');
            expect(view.showAppointmentsView).not.toHaveBeenCalled();
        });
    });
});
